/**
 ******************************************************************************
 * @file    dev_gpio.h 
 * @author  zhu_yanjun@superstunning.com
 * @date    2017/01/10
 * @brief   gpio device
 ******************************************************************************
 * @attention
 *
 *
 ******************************************************************************
 */

#include "dev_gpio.h"

/**
 * gpio info array definition
 */
static gpio_info_t gpios[GPIO_MAX];

/**
 * @function gpio_pin_config
 * @brief    gpio pin configuaration
 * @param    info - gpio info
 * @retval   none
 */
void gpio_pin_config(gpio_info_t* info)
{
	/* init GPIO for gpio  */
	GPIO_InitTypeDef GPIO_InitStructure;

	GPIO_InitStructure.GPIO_Pin = info->pin;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz; 
	GPIO_Init(info->gpio, &GPIO_InitStructure);
}

/**
 * @function gpio_init
 * @brief    gpio initialization
 * @param    none
 * @retval   none
 */
void gpio_init(void)
{
	gpios[GPIO_NAME_ENA].gpio = GPIOA;
	gpios[GPIO_NAME_ENA].pin = GPIO_Pin_3;
	gpio_pin_config(&gpios[GPIO_NAME_ENA]);
	gpio_set(GPIO_NAME_ENA);

	gpios[GPIO_NAME_DIR].gpio = GPIOA;
	gpios[GPIO_NAME_DIR].pin = GPIO_Pin_4;
	gpio_pin_config(&gpios[GPIO_NAME_DIR]);
	gpio_set(GPIO_NAME_DIR);

}

/**
 * @function gpio_reset
 * @brief    reset gpio
 * @param    name - gpio name
 * @retval   none
 */
void gpio_reset(gpio_name_t name)
{
	GPIO_ResetBits(gpios[name].gpio, gpios[name].pin);
}


/**
 * @function gpio_set
 * @brief    set gpio
 * @param    name - gpio name
 * @retval   none
 */
void gpio_set(gpio_name_t name)
{
	GPIO_SetBits(gpios[name].gpio, gpios[name].pin);
}

