/**
 ******************************************************************************
 * @file    dev_gpio.h 
 * @author  zhu_yanjun@superstunning.com
 * @date    2017/01/10
 * @brief   header file for dev_gpio.c
 ******************************************************************************
 * @attention
 *
 * 
 *
 ******************************************************************************
 */ 

#ifndef _dev_gpio_H_
#define _dev_gpio_H_

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x.h"
#include "driver.h"

/**
 * gpio name.
 */
typedef enum 
{
	GPIO_NAME_ENA = 0,
	GPIO_NAME_DIR = 1,
	GPIO_MAX = 2
}gpio_name_t;



/**
 * struct : gpio_info_t
 */
typedef struct
{
	GPIO_TypeDef* gpio;
	uint16_t pin;
}gpio_info_t;

extern void gpio_pin_config(gpio_info_t* info);
extern void gpio_init(void);

extern void gpio_reset(gpio_name_t name);
extern void gpio_set(gpio_name_t name);

#endif

