/**
 ******************************************************************************
 * @file    dev_log.h 
 * @author  zhu_yanjun@superstunning.com
 * @date    2017/01/10
 * @brief   uart input/output
 ******************************************************************************
 * @attention
 *
 *
 ******************************************************************************
 */

#include "dev_log.h"

/**
 * usart object for log
 */
static usart_t* log_usart = null;
static drv_message_t log_message;
static bool input_mode = false;

/**
 * @function log_debug
 * @brief    log information print
 * @param    str - information string
 * @retval   none
 */
void log_debug(char* str)
{
	if (log_usart && !input_mode)
	{
		log_usart->send_string(str);
	}
}
/**
 * @function log_message_parser
 * @brief    message parser
 * @param    data - data from rx
 * @retval   none
 */
drv_message_t* log_message_parser(uint8_t data)
{
	drv_message_t* msg = null;
	
	if (input_mode)
	{
		bool output = true;
		
		// save input char to buffer.
		if (data == '\r')
		{
			if (log_message.size > 0)
			{
				input_mode = false;
				log_usart->send_byte('\n');
				log_message.message[log_message.size] = '\0';
				log_message.size ++;
				msg = &log_message;
			}
			else
			{
				output = false;
				log_usart->send_string("\n\r>");
				log_message.size = 0;
			}
		}
		else if (data == '\b')
		{
			if (log_message.size == 0)
			{
				output = false;
			}
			else
			{
				log_usart->send_byte('\b');
				log_usart->send_byte(' ');
				log_message.size--;
			}
		}
		else if (data == '\3')
		{
			input_mode = false;
			log_usart->send_string("\r\n");
		}
		else 
		{
			log_message.message[log_message.size] = data;
			log_message.size++;
		}
		
		if (output)
		{
			log_usart->send_byte(data);
		}
	}
	else
	{
		if (data == '\r')
		{
			log_usart->send_string("\n\r>");
			input_mode = true;
			log_message.size = 0;
		}
	}
	
	return msg;
	
}

/**
 * @function log_init
 * @brief    log initialization
 * @param    usart - usart object for log
 * @retval   none
 */
void log_init(usart_t* usart)
{
	log_usart = usart;
	log_message.size = 0;
}
