/**
 ******************************************************************************
 * @file    driver.h 
 * @author  zhu_yanjun@superstunning.com
 * @date    2017/01/10
 * @brief   driver for system
 ******************************************************************************
 * @attention
 *
 *
 ******************************************************************************
 */

#include "driver.h"


/**
 * @function drv_string_split
 * @brief    split a string with c
 * @param    str - source string.
 * @param    c - split symbol
 * @retval   the next position of split symbol char.
 */
char* drv_string_split(char* str, char c)
{
	char* ptr = str;
	
	for (ptr = str; *ptr; ptr++)
	{
		if (*ptr == c)
		{
			*ptr = '\0';
			ptr++;
			return ptr;
		}
	}
	
	return null;
}

/**
 * @function drv_string_upper
 * @brief    convert to upper char.
 * @param    str - source string.
 * @retval   none
 */
void drv_string_upper(char* str)
{
	if (str)
	{
		char* ptr = str;
		while(*ptr)
		{
			if (*ptr <= 'z' && *ptr >= 'a')
			{
				*ptr -= 32;
			}
			
			// next char.
			ptr++;
		}
	}
}

/**
 * @function drv_string_lower
 * @brief    convert to lower char.
 * @param    str - source string.
 * @retval   none
 */
void drv_string_lower(char* str)
{
	if (str)
	{
		char* ptr = str;
		while(*ptr)
		{
			if (*ptr <= 'Z' && *ptr >= 'A')
			{
				*ptr += 32;
			}
			
			// next char.
			ptr++;
		}
	}
}

/**
 * @function drv_sys_init
 * @brief    system initialization
 * @param    none
 * @retval   none
 */
void drv_sys_init(void)
{
  	//--------------------------- CLK INIT, HSE/HSI PLL ----------------------------
	ErrorStatus HSEStartUpStatus;
	
	//RCC reset
	RCC_DeInit();
	//Enable HSE
	RCC_HSEConfig(RCC_HSE_ON); 
	//Wait HSE is ready
	HSEStartUpStatus = RCC_WaitForHSEStartUp();
	//If HSE start fail, wail and wail.
	while(HSEStartUpStatus == ERROR)
	{
	}
	//Set bus clock
   	RCC_HCLKConfig(RCC_SYSCLK_Div1);
	RCC_PCLK1Config(RCC_HCLK_Div2);
	RCC_PCLK2Config(RCC_HCLK_Div1);
	//HSE8M PLL-> 8 x 9 = 72M
	RCC_PLLConfig(RCC_PLLSource_HSE_Div1, RCC_PLLMul_9);
	RCC_PLLCmd(ENABLE); 
	while(RCC_GetFlagStatus(RCC_FLAG_PLLRDY) == RESET)
	{
	}
	//Select PLL as system clock source
   	RCC_SYSCLKConfig(RCC_SYSCLKSource_PLLCLK);
	while(RCC_GetSYSCLKSource() != 0x08)
	{
	}

	//----------------------------- CLOSE HSI ---------------------------
	RCC_HSICmd(DISABLE);
	//
	SystemCoreClockUpdate();

	//--------------------------- OPEN GPIO CLK -------------------------
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOA, ENABLE);
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB, ENABLE);
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOC, ENABLE);
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOD, ENABLE);
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOE, ENABLE);
	RCC_APB2PeriphClockCmd(RCC_APB2Periph_AFIO, ENABLE);

	// JTEG CONFIG
	GPIO_PinRemapConfig(GPIO_Remap_SWJ_JTAGDisable, ENABLE);

	//---------------------------- INT CONFIG ---------------------------
	//2-level interrupt 
	NVIC_PriorityGroupConfig(NVIC_PriorityGroup_2);
   	
	// open IRQ
	__enable_irq();

	//---------------------------- JTAG CONFIG ---------------------------
	//JTAG/SWD disable
	//GPIO_PinRemapConfig(GPIO_Remap_SWJ_JTAGDisable, ENABLE);
	//GPIO_PinRemapConfig(GPIO_Remap_SWJ_Disable, ENABLE);
	
}		   
