/*--------------------------------------------------------------------------------------
*  @file     drv_pwm.c
*  @author   zhu_yanjun@superstunning.com
*  @version  base on stm32f10x   
*  @date     2017.01.10
*  @brief    none
---------------------------------------------------------------------------------------*/

/* INCLUDES */
#include "drv_pwm.h"

/*-------------------------------------------------------------------------------------------------------
*  internal declaration
-------------------------------------------------------------------------------------------------------*/

/*-------------------------------------------------------------------------------------------------------
*  resource declaration
-------------------------------------------------------------------------------------------------------*/




/*-------------------------------------------------------------------------------------------------------
*  function declaration
-------------------------------------------------------------------------------------------------------*/


/*-------------------------------------------------------------------------------------------------------
*  functions
-------------------------------------------------------------------------------------------------------*/


/***********************************************************
 * class : drv_pwm
 ***********************************************************/



/**
 * @function drv_pwm::init
 * @brief    
 * @param    none
 * @retval   none
 */
void drv_pwm_init(void)
{
	TIM_TimeBaseInitTypeDef TIM_TimeBaseStructure;
	TIM_OCInitTypeDef  TIM_OCInitStructure;
	GPIO_InitTypeDef GPIO_InitStructure;
	
	
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_1;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;  
	GPIO_Init(GPIOA, &GPIO_InitStructure);
	
	
	// timer config (pwm)
	RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM2, DISABLE);
	TIM_CtrlPWMOutputs(TIM2, DISABLE);
	TIM_Cmd(TIM2, DISABLE);
	
	//
	RCC_APB1PeriphClockCmd(RCC_APB1Periph_TIM2, ENABLE);
	
	//
	TIM_TimeBaseStructure.TIM_Period = 36000;
	TIM_TimeBaseStructure.TIM_Prescaler = 0;
	TIM_TimeBaseStructure.TIM_ClockDivision = TIM_CKD_DIV1;
	TIM_TimeBaseStructure.TIM_CounterMode = TIM_CounterMode_Up;
	TIM_TimeBaseInit(TIM2, &TIM_TimeBaseStructure);

	//
	TIM_OCInitStructure.TIM_OCMode = TIM_OCMode_PWM1;
	TIM_OCInitStructure.TIM_OutputState = TIM_OutputState_Enable;
	TIM_OCInitStructure.TIM_Pulse = 18000;
	TIM_OCInitStructure.TIM_OCPolarity =TIM_OCPolarity_High;
	TIM_OCInitStructure.TIM_OCIdleState = TIM_OCIdleState_Reset;
	
	TIM_OC2Init(TIM2, &TIM_OCInitStructure);
	
	TIM_CtrlPWMOutputs(TIM2, ENABLE);
	TIM_Cmd(TIM2, ENABLE);
}



/**
 * @function drv_pwm::change_freq
 * @brief    change pwm freq
 * @param    freq - pwm freq
 * @retval   none
 */
void drv_pwm_change_freq(float freq)
{
	uint32_t value;
	uint16_t prescaler;
	uint16_t period;
	uint16_t du;

	if (freq == 0)
	{
		freq = 100;
		du = 0;
	}
	else
	{
		du = 1;
	}

	value = SystemCoreClock / (freq * 2);
	
	prescaler = value >> 16;
	prescaler ++;
	period = value / prescaler;
	
	TIM_SetAutoreload(TIM2, period - 1);
	TIM_PrescalerConfig(TIM2, prescaler - 1, TIM_PSCReloadMode_Immediate);
	
	TIM_SetCompare2(TIM2, (du == 0)?0:(period / 2));
}

