/**
 ******************************************************************************
 * @file    drv_uart.h 
 * @author  zhu_yanjun@superstunning.com
 * @date    2017/01/10
 * @brief   header file for drv_uart.c
 ******************************************************************************
 * @attention
 *
 * 
 *
 ******************************************************************************
 */ 

#ifndef _DRV_UART_H_
#define _DRV_UART_H_

/* Includes ------------------------------------------------------------------*/
#include "stm32f10x.h"
#include "driver.h"

/**
 * usart type definition
 */
typedef struct
{
	void (*send_byte)(uint8_t data);
	void (*send_data)(uint8_t* data, uint16_t size);
	void (*send_string)(char* str);
	
	drv_message_t* (*message_parser)(uint8_t data);
	void (*message_handler)(drv_message_t* message);
	
	void (*config)(uint32_t baudrate);
	void (*run)(void);
}usart_t;

extern usart_t usart1;

extern void usart1_handler(void);

extern void usart_init(void);
extern void usart_set_message_parser(usart_t* usart, drv_message_t* (*parser)(uint8_t data));
extern void usart_set_message_handler(usart_t* usart, void (*handler)(drv_message_t* message));


#endif

