/**
 ******************************************************************************
 * @file    app.h 
 * @author  zhu_yanjun@superstunning.com
 * @date    2017/01/10
 * @brief   application processing
 ******************************************************************************
 * @attention
 *
 *
 ******************************************************************************
 */

#include "string.h"
#include "stdlib.h"
#include "app.h"
#include "drv_uart.h"
#include "dev_gpio.h"
#include "drv_pwm.h"
#include "dev_log.h"

/**
 * @function app_message_handler
 * @brief    application message handler
 * @param    none
 * @retval   none
 */
void app_message_handler(drv_message_t* message)
{
	// process
	char* cmd = (char*)message->message;
	char* param = drv_string_split(cmd, ' ');
	
	if (strcmp(cmd, "speed") == 0)
	{
		int speed = atoi(param);
		
		if (speed < 0)
		{
			gpio_reset(GPIO_NAME_DIR);
		}
		else
		{
			gpio_set(GPIO_NAME_DIR);
		}
		
		drv_pwm_change_freq(abs(speed));
	}
	else if (strcmp(cmd, "enable") == 0)
	{
		gpio_set(GPIO_NAME_ENA);
	}
	else if (strcmp(cmd, "disable") == 0)
	{
		gpio_reset(GPIO_NAME_ENA);
		drv_pwm_change_freq(0);
	}
	else if (strcmp(cmd, "help") == 0)
	{
		log_debug("[VSMD101_025T HELP]\r\n\r\n");
		log_debug("  pins :\r\n\r\n");
		log_debug("    PA1 - STP.\r\n");
		log_debug("    PA3 - ENA.\r\n");
		log_debug("    PA4 - DIR.\r\n\r\n");
		log_debug("  command list :\r\n\r\n");
		log_debug("    enable - enable motor.\r\n");
		log_debug("    disable - disable motor.\r\n");
		log_debug("    speed [value] - set speed.\r\n");
		log_debug("      speed == 0, stop.\r\n");
		log_debug("      speed > 0, forward-rotating.\r\n");
		log_debug("      speed < 0, reverse-rotating.\r\n");
	}
}

/**
 * @function app_init
 * @brief    application initialization
 * @param    none
 * @retval   none
 */
static void app_init(void)
{
	drv_sys_init();
	gpio_init();
	usart_init();
	usart1.config(115200);
	log_init(&usart1);
	
	usart_set_message_parser(&usart1, log_message_parser);
	usart_set_message_handler(&usart1, app_message_handler);
	drv_pwm_init();
	
	gpio_reset(GPIO_NAME_ENA);
	drv_pwm_change_freq(0);
	
	
	log_debug("VSMD101_025T TEST\r\n");
	log_debug("Enter [help] to get more.\r\n");
}

/**
 * @function app_run
 * @brief    application initialization
 * @param    none
 * @retval   none
 */
static void app_run(void)
{
	usart1.run();
}

/**
 * @function app_main
 * @brief    application main function
 * @param    none
 * @retval   none
 */
void app_main(void)
{
	app_init();
	while(true)
	{
		app_run();
	}
}
